// Listing 9-6

public class Listing9_6
{
   public static void main(String[] args)
   {
      // Tablica liczb typu int
      int[] numbers = { 4, 6, 1, 3, 5, 2 };

      // Licznik pętli
      int index;
      
      // Wyświetlamy elementy tablicy w pierwotnej kolejności
      System.out.println("Pierwotna kolejność:");
      for (index = 0; index < numbers.length; index++)
         System.out.println(numbers[index]);
      
      // Sortujemy tablicę
      insertionSort(numbers);

      // Wstawiamy pustą linię
      System.out.println();

      // Wyświetlamy posortowaną tablicę
      System.out.println("Posortowane liczby:");
      for (index = 0; index < numbers.length; index++)
         System.out.println(numbers[index]);
   }

   //   Metoda insertionSort wykonuje na tablicy liczb int
   //   sortowanie przez wstawianie; elementy zostaną posortowane w koleności rosnącej

   public static void insertionSort(int[] array)
   {
      int unsortedValue;  // Zmienna, w której zapiszemy pierwszą nieposortowaną wartość
      int scan;           // Zmienna, za pomocą której będziemy śledzili tablicę
      
      // W zmiennej index będą zapisywane w pętli kolejne indeksy,
      // począwszy od indeksu numer 1, dlatego, 
      // że element o indeksie 0 uważamy za już posortowany
      for (int index = 1; index < array.length; index++)
      {
         // Pierwszy element występujący zaraz za posortowanym fragmentem
         // tablicy to array[index]. W zmiennej unsortedValue zapisujemy
         // wartość przypisaną do tego elementu
         unsortedValue = array[index];
         
         // Śledzenie zaczynamy od indeksu pierwszego elementu,
         // zaraz za posortowanym fragmentem tablicy
         scan = index;
         
         // Przenosimy pierwszy element spoza posortowanego fragmentu
         // w odpowiednie miejsce posortowanego fragmentu
         while (scan > 0 && array[scan-1] > unsortedValue)
         {
            array[scan] = array[scan - 1];
            scan--;
         }
         
         // Wstawiamy wartość nieposortowaną we właściwe miejsce
         // posortowanego fragmentu tablicy
         array[scan] = unsortedValue;
      }
   }
}